//
//  MCFileLogger.h
//  MCFoundation
//
//  Created by Michael Clark on 20/03/07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface MCFileLogger : NSObject {
	@protected
	NSString*       __logFilePath;
	int             __rotationThreshold;
	
	NSFileHandle*   __outputFile;
}

- (id)initWithLogFilePath: (NSString*)logFilePath;
- (id)initWithLogFilePath: (NSString*)logFilePath rotationThreshold: (unsigned)rotationThreshold;
	// rotationThreshold allows you to specify how many log file you want in rotation, or none at all.
	//  If you pass 0 for rotationThreshold it will append to an existing file at logFilePath, or create a new one if not found
	//  If you pass x for rotationThreshold then it will move an existing file at logFilePath to logFilePath.1 after rotating our existing backups
	//  It will be possible to have logFilePath.[1..x] in place, plus the current logFilePath (i.e. you could have x+1 log files)


- (void)logDebug:(NSString *)format, ...;
- (void)logVerbose:(NSString *)format, ...;
- (void)logInfo:(NSString *)format, ...;
- (void)logWarn:(NSString *)format, ...;
- (void)logError:(NSString *)format, ...;


- (void)logDebugString:(NSString *)string;
- (void)logVerboseString:(NSString *)string;
- (void)logInfoString:(NSString *)string;
- (void)logWarnString:(NSString *)string;
- (void)logErrorString:(NSString *)string;



- (NSString *)logFilePath;
- (int)rotationThreshold;

@end
